/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.scc.model.policies;

import com.vistara.scc.model.rules.RuleEntity;
import com.vistara.sdk.utils.StringUtil;
import java.util.Arrays;
import java.util.List;

public enum GlobalActionType {
    ANY_DEVICE("device"),
    ANY_SERVICE("servicegroup"),
    ANY_CLOUD_RESOURCE("cloudresource"),
    RDS("rds"),
    DYNAMO_DB("dynamodb"),
    ELASTICACHE("elasticache"),
    REDSHIFT("redshift"),
    ROUTE_53("route53"),
    ELASTICMAPREDUCE("emr"),
    SNS("sns"),
    SQS("sqs"),
    EBS("ebs"),
    LOAD_BALANCER("elb"),
    AUTO_SCALING("autoscaling"),
    AFFINITY_GROUP("AffinityGroup"),
    CLOUD_SERVICE("CloudService"),
    KINESIS("kinesis"),
    LAMBDA("lambda"),
    MACHINE_LEARNING("machinelearning"),
    STORAGE_GATEWAY("storagegateway"),
    CLOUDFRONT("cloudfront"),
    WEBSITE("WebSite"),
    SQL_SERVER("SQL Server"),
    SQL_DATABASE("SQL Database");

    private String name;

    private GlobalActionType(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static RuleEntity getRuleEntityByGAT(GlobalActionType gat) {
        if (gat != null) {
            switch (gat.name()) {
                case "ANY_DEVICE": {
                    return RuleEntity.DEVICE;
                }
            }
            return RuleEntity.lookup(gat.name());
        }
        return null;
    }

    public static List<GlobalActionType> getGlobalActionTypeByCloudType(String cloudType) {
        if (!StringUtil.isEmpty(cloudType)) {
            switch (cloudType.toUpperCase()) {
                case "AWS": {
                    return Arrays.asList(ANY_CLOUD_RESOURCE, AUTO_SCALING, CLOUDFRONT, DYNAMO_DB, ANY_DEVICE, ELASTICACHE, ELASTICMAPREDUCE, KINESIS, LAMBDA, LOAD_BALANCER, MACHINE_LEARNING, RDS, REDSHIFT, ROUTE_53, SNS, SQS, STORAGE_GATEWAY, EBS);
                }
                case "AZURE": {
                    return Arrays.asList(ANY_CLOUD_RESOURCE, AFFINITY_GROUP, CLOUD_SERVICE, ANY_DEVICE, EBS, WEBSITE, SQL_SERVER, SQL_DATABASE);
                }
                case "GOOGLE": {
                    return Arrays.asList(ANY_CLOUD_RESOURCE, ANY_DEVICE);
                }
            }
            return null;
        }
        return null;
    }
}

